<?php
include 'header.php';
?>

<style>
body {
    background-color: #f4f6f9;
}

/* Card principal */
.card {
    border: none;
    border-radius: 1rem;
    box-shadow: 0 4px 20px rgba(0,0,0,0.08);
}

/* Encabezado */
.card-header {
    background: linear-gradient(90deg, #007bff, #00bcd4);
    color: #fff;
    font-weight: 600;
    border-top-left-radius: 1rem;
    border-top-right-radius: 1rem;
    padding: 1rem 1.5rem;
}

.card-header .btn {
    font-weight: 600;
    border-radius: 8px;
}

/* Botones */
.btn-success {
    background: linear-gradient(90deg, #28a745, #20c997);
    border: none;
}
.btn-success:hover {
    background: linear-gradient(90deg, #20c997, #28a745);
    transform: scale(1.05);
}

/* Tabla */
.table {
    border-radius: 10px;
    overflow: hidden;
}
.table thead {
    background: linear-gradient(90deg, #007bff, #00bcd4);
    color: #fff;
    font-size: 14px;
    text-transform: uppercase;
}
.table-hover tbody tr:hover {
    background-color: #e3f2fd !important;
    transition: all 0.2s ease;
}

/* Botones de acción */
.btn-outline-primary, .btn-outline-danger {
    border-radius: 8px;
    transition: 0.3s;
}
.btn-outline-primary:hover {
    background: #007bff;
    color: white;
}
.btn-outline-danger:hover {
    background: #dc3545;
    color: white;
}

/* Animación de la tabla */
tbody tr {
    transition: transform 0.15s ease-in-out;
}
tbody tr:hover {
    transform: scale(1.01);
}

/* Etiquetas */
.badge {
    font-size: 0.8rem;
    border-radius: 8px;
}

/* Breadcrumbs */
.breadcrumbs {
    background: none;
}
.breadcrumb {
    background: transparent;
    margin-bottom: 0;
}
.breadcrumb li a {
    color: #007bff;
    text-decoration: none;
}
.breadcrumb li.active {
    color: #333;
}
</style>

<div class="breadcrumbs">
    <div class="col-sm-4">
        <div class="page-header float-left">
            <div class="page-title">
                <h1>Dashboard</h1>
            </div>
        </div>
    </div>
    <div class="col-sm-8">
        <div class="page-header float-right">
            <div class="page-title">
                <ol class="breadcrumb text-right">
                    <li><a href="#">Dashboard</a></li>
                    <li><a href="#">Admin</a></li>
                    <li class="active">Seguro Vehicular</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content mt-3">
    <div class="animated fadeIn">
        <div class="row">

            <div class="col-12">
                <div class="card shadow-sm border-0">

                    <!-- Encabezado elegante -->
                    <div class="card-header d-flex justify-content-between align-items-center flex-wrap">
                        <strong class="card-title">Seguros Vehiculares</strong>
                        <button type="button" class="btn btn-success btn-sm" data-toggle="modal" data-target="#largeModal">
                            <i class="fa fa-plus-circle"></i> Nuevo Seguro
                        </button>
                    </div>

                    <div class="card-body">
                        <!-- Mensaje de sesión -->
                        <?php if (isset($_SESSION['message'])): ?>
                            <div class="alert alert-success text-center mt-2">
                                <?= $_SESSION['message']; unset($_SESSION['message']); ?>
                            </div>
                        <?php endif; ?>

                        <div class="table-responsive mt-3">
                            <table id="example" class="table table-bordered table-striped table-hover nowrap" style="width:100%">
                                <thead style="background-color:#346eb2;color:#ffffff">
                                    <tr>
                                        <th>#</th>
                                        <th>Acciones</th>
                                        <th>Nro. Placa</th>
                                        <th>Compañía de Seguros</th>
                                        <th>Nro. de Póliza</th>
                                        <th>Fecha Inicio</th>
                                        <th>Fecha Vencimiento</th>
                                        <th>Fecha de Creación</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    include '../config/conexion.php';
                                    $database = new Connection();
                                    $db = $database->open();
                                    try {    
                                        $sql = "SELECT * FROM seguro ORDER BY id DESC";
                                        foreach ($db->query($sql) as $row): ?>
                                            <tr>
                                                <td><?= $row['id']; ?></td>
                                                <td>
                                                    <div class="btn-group btn-group-sm" role="group">
                                                       <button class="btn btn-danger" onclick="confirmDelete(<?= $row['id']; ?>, '<?= $row['nro_placa']; ?>')">
    <i class="fa fa-trash"></i>
</button>
                                                    </div>
                                                </td>
                                                <td><?= $row['nro_placa']; ?></td>
                                                <td><?= $row['aseguradora']; ?></td>
                                                <td><?= $row['nro_poliza_seguro']; ?></td>
                                                <td><?= $row['fecha_inicio']; ?></td>
                                                <td><?= $row['fecha_vto']; ?></td>
                                                <td><?= $row['fecha_creacion']; ?></td>
                                            </tr>
                                    <?php endforeach;
                                    } catch (PDOException $e) {
                                        echo "<tr><td colspan='8'>Error: " . $e->getMessage() . "</td></tr>";
                                    }
                                    $database->close();
                                    ?>
                                </tbody>
                                <tfoot style="background-color:#346eb2;color:#ffffff">
                                    <tr>
                                        <th>#</th>
                                        <th>Acciones</th>
                                        <th>Nro. Placa</th>
                                        <th>Compañía de Seguros</th>
                                        <th>Nro. de Póliza</th>
                                        <th>Fecha Inicio</th>
                                        <th>Fecha Vencimiento</th>
                                        <th>Fecha de Creación</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div> <!-- /.table-responsive -->
                    </div> <!-- /.card-body -->
                </div> <!-- /.card -->
            </div> <!-- /.col -->

        </div> <!-- /.row -->
    </div> <!-- /.animated -->
</div> <!-- /.content -->

<?php
include 'footer.php';
include '../modal/seguro.php';
?>

<script>
    // Inicialización DataTables con idioma español y botones
    new DataTable('#example', {
        responsive: true,
        layout: {
            topStart: {
                buttons: ['copy', 'csv', 'excel', 'pdf', 'print']
            }
        },
        language: {
            url: 'https://cdn.datatables.net/plug-ins/1.13.6/i18n/es-ES.json'
        }
    });

    // Alerta informativa inicial
</script>

<script>
function confirmDelete(id, placa) {
  Swal.fire({
    title: '¿Eliminar Seguro Vehicular?',
    html: `Estás a punto de eliminar el seguro del vehículo con placa <b>${placa}</b>.<br>Esta acción no se puede deshacer.`,
    icon: 'warning',
    showCancelButton: true,
    confirmButtonText: 'Sí, eliminar',
    cancelButtonText: 'Cancelar',
    confirmButtonColor: '#d33',
    cancelButtonColor: '#3085d6',
    reverseButtons: true
  }).then((result) => {
    if (result.isConfirmed) {
      // Redirigir al controlador de eliminación
      window.location.href = `../controller/delete_seguro.php?id=${id}`;
    }
  });
}
</script>
