<?php
include 'header.php'; 

if ($_SERVER["REQUEST_METHOD"] === "POST") {
  $lat = $_POST['lat'] ?? null;
  $lng = $_POST['lng'] ?? null;

  if ($lat && $lng) {
    echo "✅ Coordenadas recibidas:<br>Latitud: $lat<br>Longitud: $lng";
  } else {
    echo "⚠️ No se recibieron coordenadas.";
  }
}
?>

<div class="content mt-3">
    <div class="animated fadeIn">
        <div class="card shadow-sm border-0">
            <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                <h5 class="mb-0"><i class="fa fa-user-circle"></i> Lista de Usuarios</h5>
                <button type="button" class="btn btn-light btn-sm text-primary font-weight-bold" data-toggle="modal" data-target="#largeModal">
                    <i class="fa fa-plus-circle"></i> Nuevo Usuario
                </button>
            </div>

            <?php if(isset($_SESSION['message'])): ?>
                <div class="alert alert-success text-center mt-2">
                    <?= $_SESSION['message']; unset($_SESSION['message']); ?>
                </div>
            <?php endif; ?>

            <div class="card-body">
                <div class="table-responsive">
  <h2>📍 Captura de Geolocalización</h2>

  <form method="POST" id="geoForm">
    <input type="hidden" name="lat" id="lat">
    <input type="hidden" name="lng" id="lng">
    <button type="submit">Enviar ubicación</button>
  </form>

  <script>
    // Al cargar la página, pedimos la ubicación
    window.onload = function () {
      if (navigator.geolocation) {
        navigator.geolocation.getCurrentPosition(
          function (pos) {
            document.getElementById("lat").value = pos.coords.latitude;
            document.getElementById("lng").value = pos.coords.longitude;

            console.log("✅ Coordenadas detectadas:");
            console.log("Lat:", pos.coords.latitude);
            console.log("Lng:", pos.coords.longitude);

            Swal.fire({
              icon: 'success',
              title: 'Ubicación detectada',
              text: `Lat: ${pos.coords.latitude}, Lng: ${pos.coords.longitude}`
            });
          },
          function (err) {
            console.error("❌ Error de geolocalización:", err);
            Swal.fire({
              icon: 'error',
              title: 'Error',
              text: 'No se pudo obtener la ubicación. Activa los permisos de geolocalización en tu navegador.'
            });
          }
        );
      } else {
        Swal.fire({
          icon: 'warning',
          title: 'No soportado',
          text: 'Tu navegador no soporta geolocalización.'
        });
      }
    };
  </script>

                </div>
            </div>
        </div>
    </div>
</div>

<?php
include 'footer.php';
include '../modal/usuario.php';
include '../modal/editar_usuario.php';
?>

