<?php
include 'header.php'; 
?>

<div class="content mt-3">
    <div class="animated fadeIn">
        <div class="card shadow-sm border-0">
            <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                <h5 class="mb-0"><i class="fa fa-user-circle"></i> Lista de Usuarios</h5>
                <button type="button" class="btn btn-light btn-sm text-primary font-weight-bold" data-toggle="modal" data-target="#largeModal">
                    <i class="fa fa-plus-circle"></i> Nuevo Usuario
                </button>
            </div>

            <?php if(isset($_SESSION['message'])): ?>
                <div class="alert alert-success text-center mt-2">
                    <?= $_SESSION['message']; unset($_SESSION['message']); ?>
                </div>
            <?php endif; ?>

            <div class="card-body">
                <div class="table-responsive">
                    <table id="example" class="table table-striped table-hover nowrap" style="width:100%">
                        <thead class="bg-primary text-white">
                            <tr class="text-center">
                                <th>#</th>
                                <th>Acciones</th>
                                <th>Nro. Documento</th>
                                <th>Nombres</th>
                                <th>F. Nacimiento</th>
                                <th>F. Ingreso</th>
                                <th>Dirección</th>
                                <th>Usuario</th>
                                <th>Contraseña</th>
                                <th>Rol</th>
                                <th>Contacto</th>
                            </tr>
                        </thead>
                        <tbody class="text-center">
                            <?php
                            include '../config/conexion.php';
                            $database = new Connection();
                            $db = $database->open();
                            try {
                                $sql = 'SELECT * FROM usuarios';
                                foreach ($db->query($sql) as $row): 
                                    $password = htmlspecialchars($row['pass']);
                            ?>
                                    <tr>
                                        <td><?= $row['id']; ?></td>
                                        <td>
                                            <div class="btn-group btn-group-sm" role="group">
                                               <button 
                                                class="btn btn-outline-primary btn-sm" 
                                                title="Editar" 
                                                onclick="openEditModal(
                                                    <?= $row['id']; ?>,
                                                    '<?= htmlspecialchars($row['nro_document']); ?>',
                                                    '<?= htmlspecialchars($row['fullname']); ?>',
                                                    '<?= htmlspecialchars($row['direccion']); ?>',
                                                    '<?= htmlspecialchars($row['nro_contacto']); ?>',
                                                    '<?= htmlspecialchars($row['fecha_nacimiento']); ?>',
                                                    '<?= htmlspecialchars($row['fecha_ingreso']); ?>',
                                                    '<?= htmlspecialchars($row['rol']); ?>'
                                                )">
                                                <i class="fa fa-pencil"></i>
                                            </button><button class="btn btn-outline-warning btn-sm" title="Cambiar Contraseña"
                                                        onclick="openChangePasswordModal(<?= $row['id']; ?>, '<?= htmlspecialchars($row['fullname']); ?>')">
                                                        <i class="fa fa-key"></i>
                                                    </button>

                                                <a href="#" class="btn btn-outline-danger btn-sm" title="Eliminar" onclick="confirmDelete(<?= $row['id']; ?>)">
                                                    <i class="fa fa-trash"></i>
                                                </a>
                                            </div>
                                        </td>
                                        <td><?= $row['nro_document']; ?></td>
                                        <td><?= $row['fullname']; ?></td>
                                        <td><?= $row['fecha_nacimiento']; ?></td>
                                        <td><?= $row['fecha_ingreso']; ?></td>
                                        <td><?= $row['direccion']; ?></td>
                                        <td><?= $row['usuario']; ?></td>

                                        <!-- Campo de contraseña con "ojito" -->
                                        <td>
                                            <span class="badge badge-secondary password-text" id="pass_<?= $row['id']; ?>">••••••</span>
                                            <button class="btn btn-link btn-sm text-dark p-0" onclick="togglePassword(<?= $row['id']; ?>, '<?= $password; ?>')" title="Mostrar/Ocultar">
                                                <i class="fa fa-eye" id="eye_<?= $row['id']; ?>"></i>
                                            </button>
                                        </td>

                                        <td>
                                            <?php if($row['rol'] == 'admin'): ?>
                                                <span class="badge badge-danger">Administrador</span>
                                            <?php elseif($row['rol'] == 'vigilancia'): ?>
                                                <span class="badge badge-warning text-dark">Vigilancia</span>
                                            <?php else: ?>
                                                <span class="badge badge-info">Conductor</span>
                                            <?php endif; ?>
                                        </td>
                                        <td><?= $row['nro_contacto']; ?></td>
                                    </tr>
                            <?php 
                                endforeach;
                            } catch(PDOException $e) {
                                echo "<tr><td colspan='11'>Error: " . $e->getMessage() . "</td></tr>";
                            }
                            $database->close();
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
include 'footer.php';
include '../modal/usuario.php';
include '../modal/editar_usuario.php';
include '../modal/change_pass.php';

?>

<!-- DataTables -->
<script>
new DataTable('#example', {
    responsive: true,
    layout: {
        topStart: {
            buttons: ['copy', 'csv', 'excel', 'pdf', 'print']
        }
    },
    language: { url: 'https://cdn.datatables.net/plug-ins/1.13.6/i18n/es-ES.json' }
});
</script>

<!-- SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
function confirmDelete(id) {
    Swal.fire({
        title: '¿Eliminar usuario?',
        text: "Esta acción no se puede deshacer.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#0081faff',
        confirmButtonText: 'Sí, eliminar',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            window.location.href = '../controller/delete_usuario.php?id=' + id;
        }
    })
}

//  Mostrar / ocultar contraseña
function togglePassword(id, password) {
    const passElement = document.getElementById('pass_' + id);
    const eyeIcon = document.getElementById('eye_' + id);

    if (passElement.textContent === '••••••') {
        passElement.textContent = password;
        eyeIcon.classList.remove('fa-eye');
        eyeIcon.classList.add('fa-eye-slash');
    } else {
        passElement.textContent = '••••••';
        eyeIcon.classList.remove('fa-eye-slash');
        eyeIcon.classList.add('fa-eye');
    }
}


// ---------------------------
// Confirmar eliminación
// ---------------------------
function confirmDelete(id) {
    Swal.fire({
        title: '¿Eliminar usuario?',
        text: "Esta acción no se puede deshacer.",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#0081faff',
        confirmButtonText: 'Sí, eliminar',
        cancelButtonText: 'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            window.location.href = '../controller/delete_usuario.php?id=' + id;
        }
    })
}

// ---------------------------
// Abrir modal de cambio de contraseña
// ---------------------------
function openChangePasswordModal(userId, fullname) {
    document.getElementById('change_user_id').value = userId;
    document.getElementById('new_password').value = '';
    document.getElementById('confirm_password').value = '';
    document.getElementById('password_error').textContent = '';

    const modalId = 'modalChangePassword';
    const modalElement = document.getElementById(modalId);

    if (typeof $ !== 'undefined' && typeof $.fn.modal === 'function') {
        $('#' + modalId).modal('show');
    } else if (typeof bootstrap !== 'undefined') {
        const modal = new bootstrap.Modal(modalElement);
        modal.show();
    }
}

// ---------------------------
// Validar cambio de contraseña
// ---------------------------
document.getElementById('formChangePassword').addEventListener('submit', function(e) {
    const newPass = document.getElementById('new_password').value;
    const confirmPass = document.getElementById('confirm_password').value;

    if(newPass !== confirmPass) {
        e.preventDefault();
        document.getElementById('password_error').textContent = "Las contraseñas no coinciden.";
    }
});


</script>

<script>
function openEditModal(id, nro_document, fullname, direccion, nro_contacto, fecha_nacimiento, fecha_ingreso, rol) {
    // Cargar los valores en el formulario
    document.getElementById('edit_nro_document').value = nro_document;
    document.getElementById('edit_fullname').value = fullname;
    document.getElementById('edit_direccion').value = direccion;
    document.getElementById('edit_nro_contacto').value = nro_contacto;
    document.getElementById('edit_fecha_nacimiento').value = fecha_nacimiento;
    document.getElementById('edit_fecha_ingreso').value = fecha_ingreso;
    document.getElementById('edit_rol').value = rol;

    // Actualizar acción del formulario con el ID
    document.getElementById('formEditarUsuario').action = "../controller/actualizar_usuario.php?id=" + id;

    // Mostrar el modal (compatible con Bootstrap 4 y 5)
    const modalId = 'modalEditarUsuario';
    const modalElement = document.getElementById(modalId);

    if (typeof $ !== 'undefined' && typeof $.fn.modal === 'function') {
        // Bootstrap 4 con jQuery
        $('#' + modalId).modal('show');
    } else if (typeof bootstrap !== 'undefined') {
        // Bootstrap 5 sin jQuery
        const modal = new bootstrap.Modal(modalElement);
        modal.show();
    } else {
        console.error('No se encontró Bootstrap ni jQuery para abrir el modal.');
    }
}
</script>
