<?php
include 'header.php';
include '../config/conexion.php';

try {
    $database = new Connection();
    $db = $database->open();

    // Variables para que el formulario recuerde las fechas seleccionadas
    $fechainicio_form = isset($_POST['fechainicio']) ? $_POST['fechainicio'] : '';
    $fechafin_form    = isset($_POST['fechafin']) ? $_POST['fechafin'] : '';

    if (!empty($fechainicio_form) && !empty($fechafin_form)) {
        $fechainicio = $fechainicio_form . " 00:00:00";
        $fechafin    = $fechafin_form . " 23:59:59";

        $sql = "SELECT id, placa, tipo, marca, modelo, aseguradora, nro_poliza_seguro, lat, lng, chofer, comentarios, fecha_registro
                FROM registro_unidad
                WHERE lat IS NOT NULL AND lng IS NOT NULL
                  AND fecha_registro BETWEEN :fechainicio AND :fechafin
                ORDER BY fecha_registro DESC";

        $stmt = $db->prepare($sql);
        $stmt->bindParam(':fechainicio', $fechainicio);
        $stmt->bindParam(':fechafin', $fechafin);
    } else {
        $sql = "SELECT id, placa, tipo, marca, modelo, aseguradora, nro_poliza_seguro, lat, lng, chofer, comentarios, fecha_registro
                FROM registro_unidad
                WHERE lat IS NOT NULL AND lng IS NOT NULL
                ORDER BY fecha_registro DESC";
        $stmt = $db->prepare($sql);
    }

    $stmt->execute();
    $registros = $stmt->fetchAll(PDO::FETCH_ASSOC);

} catch (PDOException $e) {
    die("Error en DB: " . $e->getMessage());
}
?>

<link rel="stylesheet" href="https://unpkg.com/leaflet/dist/leaflet.css" />

<style>
    #map { 
        height: 90vh; 
        width: 100%; 
        border-radius: 12px;
        border: 2px solid #346eb2;
    }
</style>

<div class="breadcrumbs">
    <div class="col-sm-4">
        <div class="page-header float-left">
            <div class="page-title"><h1>Dashboard</h1></div>
        </div>
    </div>
    <div class="col-sm-8">
        <div class="page-header float-right">
            <div class="page-title">
                <ol class="breadcrumb text-right">
                    <li><a href="#">Dashboard</a></li>
                    <li><a href="#">Map</a></li>
                    <li class="active">Ubicación Unidades</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content mt-4">
  <div class="animated fadeIn">
    <div class="row">
      <div class="col-lg-12">
        <div class="card shadow-lg border-0">
          <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
            <h4 class="mb-0"><i class="fa fa-map-marker-alt"></i> Ubicación de Unidades en Tiempo Real</h4>
          </div>
          <div class="card-body">
            <!-- Formulario de fechas -->
            <form action="" method="POST" class="row g-3 mb-3">
              <div class="col-md-5">
                <label class="form-label"><strong>Desde:</strong></label>
                <input type="date" name="fechainicio" value="<?= $fechainicio_form ?>" class="form-control border-primary" required>
              </div>
              <div class="col-md-5">
                <label class="form-label"><strong>Hasta:</strong></label>
                <input type="date" name="fechafin" value="<?= $fechafin_form ?>" class="form-control border-primary" required>
              </div>
              <div class="col-md-2 d-flex align-items-end">
                <button type="submit" class="btn btn-success w-100">
                  <i class="fa fa-location-arrow"></i> Consultar
                </button>
              </div>
            </form>

            <!-- Mapa -->
            <div id="map"></div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<script src="https://unpkg.com/leaflet/dist/leaflet.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    var map = L.map('map').setView([-12.0464, -77.0428], 12);
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', { attribution: '© OpenStreetMap' }).addTo(map);

    var redIcon = L.icon({
        iconUrl: 'https://raw.githubusercontent.com/pointhi/leaflet-color-markers/master/img/marker-icon-red.png',
        shadowUrl: 'https://cdnjs.cloudflare.com/ajax/libs/leaflet/1.7.1/images/marker-shadow.png',
        iconSize: [25, 41],
        iconAnchor: [12, 41],
        popupAnchor: [1, -34],
        shadowSize: [41, 41]
    });

    var registros = <?= json_encode($registros) ?>;

    if (registros.length > 0) {
        map.setView([registros[0].lat, registros[0].lng], 14);
        registros.forEach(function(reg) {
            var marker = L.marker([reg.lat, reg.lng], { icon: redIcon }).addTo(map);
            marker.bindPopup(
                "<b>Placa:</b> " + reg.placa + "<br>" +
                "<b>Tipo:</b> " + reg.tipo + "<br>" +
                "<b>Marca:</b> " + reg.marca + "<br>" +
                "<b>Modelo:</b> " + reg.modelo + "<br>" +
                "<b>Aseguradora:</b> " + reg.aseguradora + "<br>" +
                "<b>Póliza:</b> " + reg.nro_poliza_seguro + "<br>" +
                "<b>Chofer:</b> " + reg.chofer + "<br>" +
                "<b>Comentarios:</b> " + reg.comentarios + "<br>" +
                "<b>Fecha Registro:</b> " + reg.fecha_registro
            );
            marker.bindTooltip("🚗 " + reg.placa + " | " + reg.fecha_registro, { permanent: true, direction: "top", offset: [0, -10] });
        });
    } else {
        Swal.fire({
            title: "Mensaje",
            text: "No se encontraron registros de coordenadas en el rango de fecha ingresado.",
            icon: "info"
        });
    }
</script>

<?php include 'footer.php'; ?>
